#include "hal_base.h"
#include "hal_flash.h"
#include "hal_lvd.h"

uint16_t addr;			// дFLASHĵַ
uint16_t buf[2];		// дFLASHbuffer
uint16_t read[2];		// FLASHbuffer
hal_status_t status;	// պ״̬

void main() 
{
	// RAMʼ
	ram_clear();
	// ι
	CLRWDT();
	// clockʼѡHRC,Ƶʹclock 
	status = clock_init(CLOCK_SRC_HRC, CLOCK_DIV_1, DISABLE);

	// FLASHĵַΪ0x1e00,Ϊflashʼַ */
	addr = 0x1e00;
	// дFLASH2ݷֱΪ0x1234,0x8765
	buf[0] = 0x1234;
	buf[1] = 0x8765;

	// addrַڵҳ
	flash_erase(addr);

	// LVDѹֵΪ2.9V˫ؾLVD־
	lvd_init(LVD_VOL_SEL_2_9, LVD_TRIGGER_RISING_FALLING);

	// ѯLVD־LVDʱaddrд
	while (get_lvd_status() != BELOW_THRESHOLD_VOLTAGE)
		CLRWDT();

	// addrFLASHд2
	flash_write(addr, buf, 2);

	// addrFALSHַ
	flash_read(read, addr, 2);

	while (1) {
		// ι
		CLRWDT();
	}

}